<?php get_header(); ?> // ヘッダーテンプレートを取得します。

<div id="container" class="wrapper">
  <main>
    <?php if(have_posts()): ?> //もし記事が存在すれば...
      <?php while(have_posts()):the_post(); ?> // 記事を取得します。
        <?php
          $cat = get_the_category(); // 現在の記事のカテゴリを取得します。
          $catname = $cat[0]->cat_name; // 最初のカテゴリ名を取得します。
        ?>
        <article>
          <h2 class="article-title">
            <a href="<?php the_permalink(); ?>"> // 記事のリンクを取得します。
              <?php the_title(); ?> // 記事のタイトルを表示します。
            </a> 
          </h2>
          <ul class="meta">
            <li><?php the_time('Y/m/d'); ?></li> // 記事の投稿時間を表示します。
            <li><?php echo $catname; ?></li> // 記事のカテゴリ名を表示します。
          </ul>
          <a href="<?php the_permalink(); ?>"> // 記事のリンクを取得します。
            <?php the_post_thumbnail(); ?> // 記事のサムネイルを表示します。
          </a> 
          <div class="text">
            <?php
              if (mb_strlen(strip_tags(get_the_content()), 'UTF-8') > 80) {
                $content = mb_substr(strip_tags(get_the_content()), 0, 80, 'UTF-8'); 
              // 記事の本文が80文字以上の場合、最初の80文字だけを表示します。
                echo $content . '…';
              } else {
                echo strip_tags(get_the_content()); 
              // 記事の本文が80文字以下の場合、全てを表示します。
              }
            ?>
          </div>
          <div class="readmore">
            <a href="<?php the_permalink(); ?>">記事を読む</a>
          </div> 
　　　　　// "記事を読む" というリンクを表示しそれをクリックすると詳細ページに移動します。
        </article> // 上記で表示した各要素を含む記事の表示を終えます。
      <?php endwhile; ?>
    <?php endif; ?>
  </main>
</div>

<?php get_footer(); ?> // フッターテンプレートを取得します。