<?php
//CSSファイルの読込
	function mytheme_enqueue_styles() {
    	    wp_enqueue_style( 'mytheme-style', get_stylesheet_uri() );
	}
	add_action( 'wp_enqueue_scripts', 'mytheme_enqueue_styles' );
  
//ページネーションの設定
        function pagination($pages = '', $range = 2) {
        $showitems = ($range * 2) + 1;

  // 現在のページ数
  global $paged;
  if(empty($paged)) {
    $paged = 1;
  }

  // 全ページ数
  if($pages == '') {
    global $wp_query;
    $pages = $wp_query->max_num_pages;
    if(!$pages) {
      $pages = 1;
    }
  }

  // ページ数が2ぺージ以上の場合のみ、ページネーションを表示
  if(1 != $pages) {
    echo '<div class="pagination">';
    echo '<ul>';
    // 1ページ目でなければ、「前のページ」リンクを表示
    if($paged > 1) {
      echo '<li class="prev"><a href="' . esc_url(get_pagenum_link($paged - 1)) . '">前のページ</a></li>';
    }

    // ページ番号を表示（現在のページはリンクにしない）
    for ($i=1; $i <= $pages; $i++) {
      if (1 != $pages &&(!($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )) {
        if ($paged == $i) {
          echo '<li class="active">' .$i. '</li>';
        } else {
          echo '<li><a href="' . esc_url(get_pagenum_link($i)) . '">' .$i. '</a></li>';
        }
      }
    }

    // 最終ページでなければ、「次のページ」リンクを表示
    if ($paged < $pages) {
      echo '<li class="next"><a href="' . esc_url(get_pagenum_link($paged + 1)) . '">次のページ</a></li>';
    }
    echo '</ul>';
    echo '</div>';
  }
}

//サイドバーウィジェットの設定
if (function_exists('register_sidebar')) {
  register_sidebar(array(
    'name' => 'サイドバー',
    'id' => 'sidebar',
    'description' => 'サイドバーウィジェット',
    'before_widget' => '<div>',
    'after_widget' => '</div>',
    'before_title' => '<h3 class="side-title">',
    'after_title' => '</h3>'
 ));
}

//検索対象を投稿ページだけに指定
function search_filter($query) {
  if ($query -> is_search) {
    $query -> set('post_type', 'post');
  }
  return $query;
}
add_filter('pre_get_posts', 'search_filter');

//アイキャッチ画像の機能を有効化
	if ( function_exists( 'add_theme_support' ) ) {
    	      add_theme_support( 'post-thumbnails' );
	}

//Wordpressで設定したナビゲーションメニューを header.php で出力
	function my_custom_theme_setup() {
		register_nav_menus( array(
			'header_menu' => 'Header Navigation Menu',
		) );
	}
	add_action( 'after_setup_theme', 'my_custom_theme_setup' );