<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="Content-Language" content="ja">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta http-equiv="Content-Security-Policy" content="default-src 'self'">
	<meta name="author" content="Enakat">
	<meta name="description" content="あなたのSNSアカウント、多くの方に見てもらえるように拡散・宣伝代行いたします。">
	<meta name="keywords" content="">
	<meta name="robots" content="noindex, nofollow">
	<link rel="canonical" href="">
	<meta property="og:title" content="">
	<meta property="og:description" content="">
	<meta property="og:image" content="">
	<meta property="og:type" content="website">
	<meta property="og:url" content="">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
    <header>
        <div class="header_title">
            <h1>
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a>
            </h1>
        </div>
		<nav class="nav-block">
        	<?php 
				if ( has_nav_menu( 'header_menu' ) ) {
					wp_nav_menu( array(
						'theme_location' => 'header_menu',
						'container'      => 'nav',
						'container_id'   => 'navigation',
						'menu_class'     => 'custom_menu',
					) );
				}
 			?>
        </nav>
    </header>